import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/data/controller/reward/reward_controller.dart';
import 'package:viserpay/data/repo/reward/reward_repo.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay/view/screens/reward/widget/reward_faq_card.dart';

class RewardFaqScreen extends StatefulWidget {
  const RewardFaqScreen({super.key});

  @override
  State<RewardFaqScreen> createState() => _RewardFaqScreenState();
}

class _RewardFaqScreenState extends State<RewardFaqScreen> {
  int selectedIndex = -1;
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(RewardRepo(apiClient: Get.find()));
    final controller = Get.put(RewardController(rewardRepo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      // controller.initialize();
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: MyColor.screenBgColor,
      appBar: CustomAppBar(title: MyStrings.rewardFaq, isTitleCenter: true),
      body: SingleChildScrollView(
        child: GetBuilder<RewardController>(builder: (controller) {
          return Padding(
            padding: Dimensions.defaultPaddingHV,
            child: Column(
              children: List.generate(
                controller.faqs.length,
                (index) => RewardFaqCard(
                  press: () {
                    if (selectedIndex == index) {
                      selectedIndex = -1;
                    } else {
                      selectedIndex = index;
                    }
                    setState(() {});
                  },
                  selectedIndex: selectedIndex,
                  index: index,
                  question: controller.faqs[index].dataValues?.question.toString() ?? "",
                  answer: controller.faqs[index].dataValues?.answer ?? "",
                ),
              ),
            ),
          );
        }),
      ),
    );
  }
}
